/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.server.command;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.command.ArgumentExecutor;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_merchants.common.config.MerchantsConfig;
import austeretony.oxygen_merchants.common.merchant.MerchantOffer;
import austeretony.oxygen_merchants.common.merchant.MerchantProfile;
import austeretony.oxygen_merchants.server.MerchantsManagerServer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.StringUtils;

public class MerchantsArgumentOperator
implements ArgumentExecutor {
    public String getName() {
        return "merchants";
    }

    public void process(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP playerMP = null;
        if (sender instanceof EntityPlayerMP) {
            playerMP = CommandBase.func_71521_c((ICommandSender)sender);
        }
        if (args.length >= 2) {
            if (args[1].equals("-reload-profiles")) {
                MerchantsManagerServer.instance().getMerchantProfilesManager().reloadOffers(playerMP);
                OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} reloaded merchant profiles.", (Object)sender.func_70005_c_());
            } else if (args[1].equals("-profile")) {
                if (args[2].equals("-create")) {
                    if (args.length >= 6) {
                        long id = CommandBase.func_175760_a((String)args[3], (long)0L, (long)Long.MAX_VALUE);
                        String displayName = StringUtils.join((Object[])Arrays.copyOfRange(args, 5, args.length), (char)' ');
                        if (MerchantsManagerServer.instance().getMerchantProfilesManager().createProfile(playerMP, id, args[4], displayName)) {
                            OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} created merchant profile <{} ({})>.", (Object)sender.func_70005_c_(), (Object)displayName, (Object)id);
                        }
                    }
                } else if (args[2].equals("-set-name")) {
                    if (args.length >= 5) {
                        long persistentId = CommandBase.func_175760_a((String)args[3], (long)0L, (long)Long.MAX_VALUE);
                        String displayName = StringUtils.join((Object[])Arrays.copyOfRange(args, 4, args.length), (char)' ');
                        if (MerchantsManagerServer.instance().getMerchantProfilesManager().editProfileName(playerMP, persistentId, displayName)) {
                            OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} set merchnt profile <{}> display name to <{}>.", (Object)sender.func_70005_c_(), (Object)persistentId, (Object)displayName);
                        }
                    }
                } else if (args[2].equals("-set-currency")) {
                    if (args.length >= 4) {
                        long persistentId = CommandBase.func_175760_a((String)args[3], (long)0L, (long)Long.MAX_VALUE);
                        if (args.length == 4) {
                            if (!(sender instanceof EntityPlayerMP)) {
                                throw new WrongUsageException("Command available only for player!", new Object[0]);
                            }
                            if (playerMP.func_184614_ca() == ItemStack.field_190927_a) {
                                throw new WrongUsageException("Main hand is empty!", new Object[0]);
                            }
                            ItemStackWrapper stackWrapper = ItemStackWrapper.of((ItemStack)playerMP.func_184614_ca());
                            if (MerchantsManagerServer.instance().getMerchantProfilesManager().editProfileCurrency(playerMP, persistentId, stackWrapper, -1)) {
                                OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} set merchnt profile <{}> currency to item {}.", (Object)sender.func_70005_c_(), (Object)persistentId, (Object)stackWrapper);
                            }
                        } else {
                            int currencyIndex = CommandBase.func_175764_a((String)args[4], (int)0, (int)127);
                            if (MerchantsManagerServer.instance().getMerchantProfilesManager().editProfileCurrency(playerMP, persistentId, null, currencyIndex)) {
                                OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} set merchnt profile <{}> currency to virtual currency <{}>.", (Object)sender.func_70005_c_(), (Object)persistentId, (Object)currencyIndex);
                            }
                        }
                    }
                } else if (args[2].equals("-add-offer")) {
                    if (args.length == 8) {
                        if (!(sender instanceof EntityPlayerMP)) {
                            throw new WrongUsageException("Command available only for player!", new Object[0]);
                        }
                        if (playerMP.func_184614_ca() == ItemStack.field_190927_a) {
                            throw new WrongUsageException("Main hand is empty!", new Object[0]);
                        }
                        long persistentId = CommandBase.func_175760_a((String)args[3], (long)0L, (long)Long.MAX_VALUE);
                        long newOfferId = CommandBase.func_175760_a((String)args[4], (long)0L, (long)Long.MAX_VALUE);
                        int amount = CommandBase.func_175764_a((String)args[5], (int)1, (int)Short.MAX_VALUE);
                        long buyCost = CommandBase.func_175760_a((String)args[6], (long)0L, (long)Long.MAX_VALUE);
                        long sellingCost = CommandBase.func_175760_a((String)args[7], (long)0L, (long)Long.MAX_VALUE);
                        MerchantOffer offer = new MerchantOffer(newOfferId, ItemStackWrapper.of((ItemStack)playerMP.func_184614_ca()), amount, buyCost, sellingCost);
                        if (MerchantsManagerServer.instance().getMerchantProfilesManager().addMerchantOffer(playerMP, persistentId, offer)) {
                            OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} added new offer {} to merchant profile <{}>.", (Object)sender.func_70005_c_(), (Object)offer, (Object)persistentId);
                        }
                    }
                } else if (args[2].equals("-remove-offer")) {
                    if (args.length == 5) {
                        long persistentId = CommandBase.func_175760_a((String)args[3], (long)0L, (long)Long.MAX_VALUE);
                        long offerId = CommandBase.func_175760_a((String)args[4], (long)0L, (long)Long.MAX_VALUE);
                        if (MerchantsManagerServer.instance().getMerchantProfilesManager().removeMerchantOffer(playerMP, persistentId, offerId)) {
                            OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} removed merchant profile offer <{}>.", (Object)sender.func_70005_c_(), (Object)persistentId);
                        }
                    }
                } else if (args[2].equals("-remove")) {
                    if (args.length == 4) {
                        long persistentId = CommandBase.func_175760_a((String)args[3], (long)0L, (long)Long.MAX_VALUE);
                        if (MerchantsManagerServer.instance().getMerchantProfilesManager().removeProfile(playerMP, persistentId)) {
                            OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} removed merchant profile <{}>.", (Object)sender.func_70005_c_(), (Object)persistentId);
                        }
                    }
                } else if (args[2].equals("-save") && args.length == 4) {
                    long persistentId = CommandBase.func_175760_a((String)args[3], (long)0L, (long)Long.MAX_VALUE);
                    if (MerchantsManagerServer.instance().getMerchantProfilesManager().saveProfile(playerMP, persistentId)) {
                        OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} saved merchant profile <{}>.", (Object)sender.func_70005_c_(), (Object)persistentId);
                    }
                }
            } else if (args[1].equals("-open-menu") && args.length == 5) {
                EntityPlayerMP targetPlayerMP = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                long persistentId = CommandBase.func_175760_a((String)args[3], (long)0L, (long)Long.MAX_VALUE);
                boolean debug = CommandBase.func_180527_d((String)args[4]);
                MerchantProfile profile = MerchantsManagerServer.instance().getMerchantProfilesManager().openMerchantMenu(targetPlayerMP, persistentId, debug);
                if (MerchantsConfig.ADVANCED_LOGGING.asBoolean()) {
                    if (profile != null) {
                        OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} opened merchant menu <{} ({})> for player {}/{}.", (Object)sender.func_70005_c_(), (Object)profile.getDisplayName(), (Object)persistentId, (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP));
                    } else {
                        OxygenMain.LOGGER.info("[Merchants] (Operator/Console) {} failed to open merchant menu <{}> for player {}/{}.", (Object)sender.func_70005_c_(), (Object)persistentId, (Object)CommonReference.getName((Entity)targetPlayerMP), (Object)CommonReference.getPersistentUUID((Entity)targetPlayerMP));
                    }
                }
            }
        }
    }

    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-reload-profiles", "-profile", "-open-menu"});
        }
        if (args.length >= 3 && args[1].equals("-profile")) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"-create", "-set-name", "-set-currency", "-add-offer", "-remove-offer", "-remove", "-save"});
        }
        return Collections.emptyList();
    }
}

