/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_merchants.common.EnumMerchantOperation;
import austeretony.oxygen_merchants.server.MerchantsManagerServer;
import austeretony.oxygen_merchants.server.OperationsProcessor;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class PlayersManagerServer {
    private final Map<UUID, OperationsProcessor> processors = new ConcurrentHashMap<UUID, OperationsProcessor>();
    private final MerchantsManagerServer manager;

    protected PlayersManagerServer(MerchantsManagerServer manager) {
        this.manager = manager;
    }

    public OperationsProcessor getOperationsProcessor(UUID playerUUID) {
        OperationsProcessor processor = this.processors.get(playerUUID);
        if (processor == null) {
            processor = new OperationsProcessor(playerUUID);
            this.processors.put(playerUUID, processor);
        }
        return processor;
    }

    public void removeOperationsProcessor(UUID playerUUID) {
        this.processors.remove(playerUUID);
    }

    void process() {
        OxygenHelperServer.addRoutineTask(() -> {
            for (OperationsProcessor processor : this.processors.values()) {
                processor.process();
            }
        });
    }

    public void playerUnloaded(EntityPlayerMP playerMP) {
        this.removeOperationsProcessor(CommonReference.getPersistentUUID((Entity)playerMP));
    }

    public void performOperation(EntityPlayerMP playerMP, EnumMerchantOperation operation, long offerId) {
        this.getOperationsProcessor(CommonReference.getPersistentUUID((Entity)playerMP)).queueOperation(operation, offerId);
    }
}

