/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.CurrencyHelperServer;
import austeretony.oxygen_core.server.api.InventoryProviderServer;
import austeretony.oxygen_merchants.common.EnumMerchantOperation;
import austeretony.oxygen_merchants.common.merchant.MerchantOffer;
import austeretony.oxygen_merchants.common.merchant.MerchantProfile;
import austeretony.oxygen_merchants.common.network.client.CPMerchantAction;
import austeretony.oxygen_merchants.server.QueuedMerchantOperation;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class OperationsProcessor {
    private final UUID playerUUID;
    private final Queue<QueuedMerchantOperation> operations = new ConcurrentLinkedQueue<QueuedMerchantOperation>();
    @Nullable
    private MerchantProfile profile;

    public OperationsProcessor(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public void setMerchantProfile(MerchantProfile profile) {
        this.profile = profile;
    }

    public void queueOperation(EnumMerchantOperation operation, long offerId) {
        this.operations.offer(new QueuedMerchantOperation(operation, offerId));
    }

    public void process() {
        while (!this.operations.isEmpty()) {
            EntityPlayerMP playerMP;
            MerchantOffer offer;
            QueuedMerchantOperation queued = this.operations.poll();
            if (queued == null || this.profile == null || (offer = this.profile.getOffer(queued.offerId)) == null || (playerMP = CommonReference.playerByUUID((UUID)this.playerUUID)) == null) continue;
            switch (queued.operation) {
                case BUY: {
                    if (!offer.isBuyEnabled()) break;
                    this.buy(playerMP, this.profile, offer);
                    break;
                }
                case SELLING: {
                    if (!offer.isSellingEnabled()) break;
                    this.sell(playerMP, this.profile, offer);
                }
            }
        }
    }

    private void buy(EntityPlayerMP playerMP, MerchantProfile profile, MerchantOffer offer) {
        long balance;
        if (!InventoryProviderServer.getPlayerInventory().haveEnoughSpace((EntityPlayer)playerMP, offer.getStackWrapper(), offer.getAmount())) {
            return;
        }
        if (profile.isUsingVirtalCurrency()) {
            if (!CurrencyHelperServer.enoughCurrency((UUID)this.playerUUID, (long)offer.getBuyCost(), (int)profile.getCurrencyIndex())) {
                return;
            }
            CurrencyHelperServer.removeCurrency((UUID)this.playerUUID, (long)offer.getBuyCost(), (int)profile.getCurrencyIndex());
            balance = CurrencyHelperServer.getCurrency((UUID)this.playerUUID, (int)profile.getCurrencyIndex());
        } else {
            balance = InventoryProviderServer.getPlayerInventory().getEqualItemAmount((EntityPlayer)playerMP, profile.getCurrencyStackWrapper());
            if (balance < offer.getBuyCost()) {
                return;
            }
            InventoryProviderServer.getPlayerInventory().removeItem((EntityPlayer)playerMP, profile.getCurrencyStackWrapper(), (int)offer.getBuyCost());
            balance -= offer.getBuyCost();
        }
        InventoryProviderServer.getPlayerInventory().addItem((EntityPlayer)playerMP, offer.getStackWrapper(), offer.getAmount());
        this.notifyPlayer(playerMP, EnumMerchantOperation.BUY, offer, balance);
    }

    private void sell(EntityPlayerMP playerMP, MerchantProfile profile, MerchantOffer offer) {
        long balance;
        if (!profile.isUsingVirtalCurrency() && !InventoryProviderServer.getPlayerInventory().haveEnoughSpace((EntityPlayer)playerMP, offer.getStackWrapper(), (int)offer.getSellingCost())) {
            return;
        }
        if (InventoryProviderServer.getPlayerInventory().getEqualItemAmount((EntityPlayer)playerMP, offer.getStackWrapper()) < offer.getAmount()) {
            return;
        }
        if (profile.isUsingVirtalCurrency()) {
            CurrencyHelperServer.addCurrency((UUID)this.playerUUID, (long)offer.getSellingCost(), (int)profile.getCurrencyIndex());
            balance = CurrencyHelperServer.getCurrency((UUID)this.playerUUID, (int)profile.getCurrencyIndex());
        } else {
            balance = InventoryProviderServer.getPlayerInventory().getEqualItemAmount((EntityPlayer)playerMP, profile.getCurrencyStackWrapper());
            InventoryProviderServer.getPlayerInventory().addItem((EntityPlayer)playerMP, profile.getCurrencyStackWrapper(), (int)offer.getSellingCost());
            balance += offer.getSellingCost();
        }
        InventoryProviderServer.getPlayerInventory().removeItem((EntityPlayer)playerMP, offer.getStackWrapper(), offer.getAmount());
        this.notifyPlayer(playerMP, EnumMerchantOperation.SELLING, offer, balance);
    }

    public void notifyPlayer(EntityPlayerMP playerMP, EnumMerchantOperation operation, MerchantOffer offer, long balance) {
        OxygenMain.network().sendTo((Packet)new CPMerchantAction(operation, offer, balance), playerMP);
    }
}

