/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.main.EnumOxygenStatusMessage;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_merchants.common.config.MerchantsConfig;
import austeretony.oxygen_merchants.common.main.EnumMerchantsStatusMessage;
import austeretony.oxygen_merchants.common.merchant.MerchantOffer;
import austeretony.oxygen_merchants.common.merchant.MerchantProfile;
import austeretony.oxygen_merchants.common.network.client.CPSyncProfileOpenMenu;
import austeretony.oxygen_merchants.common.network.client.CPTryOpenMerchantMenu;
import austeretony.oxygen_merchants.server.MerchantsManagerServer;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class MerchantProfilesManagerServer {
    private final MerchantsManagerServer manager;

    protected MerchantProfilesManagerServer(MerchantsManagerServer manager) {
        this.manager = manager;
    }

    public void reloadOffers(@Nullable EntityPlayerMP playerMP) {
        if (MerchantsConfig.ALLOW_MANAGEMENT_INGAME.asBoolean()) {
            OxygenHelperServer.addRoutineTask(() -> this.reload(playerMP));
        }
    }

    private void reload(@Nullable EntityPlayerMP playerMP) {
        OxygenMain.LOGGER.info("[Merchants] Reloading merchant profiles...");
        Future<?> future = this.manager.getMerchantProfilesContainer().loadAsync();
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
        }
        if (playerMP != null) {
            this.manager.sendStatusMessage(playerMP, EnumMerchantsStatusMessage.PROFILES_RELOADED);
        }
        OxygenMain.LOGGER.info("[Merchants] Merchant profiles reloaded.");
    }

    @Nullable
    public MerchantProfile openMerchantMenu(EntityPlayerMP targetMP, long persistentId, boolean debug) {
        MerchantProfile profile = this.manager.getMerchantProfilesContainer().getProfileByPersistentId(persistentId);
        if (profile != null) {
            OxygenHelperServer.resetTimeOut((UUID)CommonReference.getPersistentUUID((Entity)targetMP), (int)40);
            this.manager.getPlayersManager().getOperationsProcessor(CommonReference.getPersistentUUID((Entity)targetMP)).setMerchantProfile(profile);
            OxygenMain.network().sendTo((Packet)new CPTryOpenMerchantMenu(profile.getId(), debug), targetMP);
            return profile;
        }
        return null;
    }

    public void syncProfile(EntityPlayerMP playerMP, long profileId) {
        if (OxygenHelperServer.checkTimeOut((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)40) || CommonReference.isPlayerOpped((EntityPlayer)playerMP)) {
            MerchantProfile profile = this.manager.getMerchantProfilesContainer().getProfile(profileId);
            if (profile != null) {
                OxygenMain.network().sendTo((Packet)new CPSyncProfileOpenMenu(profile), playerMP);
            }
        } else {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)0, (int)EnumOxygenStatusMessage.ACTION_TIMEOUT.ordinal(), (String[])new String[0]);
        }
    }

    public boolean createProfile(@Nullable EntityPlayerMP playerMP, long id, String fileName, String displayName) {
        if (MerchantsConfig.ALLOW_MANAGEMENT_INGAME.asBoolean()) {
            if ((displayName = displayName.trim()).length() > 24) {
                displayName = displayName.substring(0, 24);
            }
            if (displayName.isEmpty()) {
                return false;
            }
            MerchantProfile profile = new MerchantProfile(id, fileName + ".json", displayName);
            profile.setId(this.manager.getMerchantProfilesContainer().createId(id));
            profile.setCurrencyIndex(0);
            this.manager.getMerchantProfilesContainer().addProfile(profile);
            if (playerMP != null) {
                this.manager.sendStatusMessage(playerMP, EnumMerchantsStatusMessage.PROFILE_CREATED);
            }
            return true;
        }
        return false;
    }

    private void updateProfileId(MerchantProfile profile) {
        long oldId = profile.getId();
        profile.setId(this.manager.getMerchantProfilesContainer().createId(oldId));
        this.manager.getMerchantProfilesContainer().removeProfile(oldId);
        this.manager.getMerchantProfilesContainer().addProfile(profile);
    }

    public boolean editProfileCurrency(@Nullable EntityPlayerMP playerMP, long persistentId, @Nullable ItemStackWrapper stackWrapper, int currencyIndex) {
        MerchantProfile profile;
        if (MerchantsConfig.ALLOW_MANAGEMENT_INGAME.asBoolean() && (profile = this.manager.getMerchantProfilesContainer().getProfileByPersistentId(persistentId)) != null) {
            if (stackWrapper != null) {
                profile.setCurrencyStack(stackWrapper);
            } else {
                profile.setCurrencyIndex(currencyIndex);
            }
            this.updateProfileId(profile);
            if (playerMP != null) {
                this.manager.sendStatusMessage(playerMP, EnumMerchantsStatusMessage.PROFILE_UPDATED);
            }
            return true;
        }
        return false;
    }

    public boolean editProfileName(@Nullable EntityPlayerMP playerMP, long persistentId, String displayName) {
        if (MerchantsConfig.ALLOW_MANAGEMENT_INGAME.asBoolean()) {
            if ((displayName = displayName.trim()).length() > 24) {
                displayName = displayName.substring(0, 24);
            }
            if (displayName.isEmpty()) {
                return false;
            }
            MerchantProfile profile = this.manager.getMerchantProfilesContainer().getProfileByPersistentId(persistentId);
            if (profile != null) {
                profile.setDisplayName(displayName);
                this.updateProfileId(profile);
                if (playerMP != null) {
                    this.manager.sendStatusMessage(playerMP, EnumMerchantsStatusMessage.PROFILE_UPDATED);
                }
                return true;
            }
        }
        return false;
    }

    public boolean addMerchantOffer(@Nullable EntityPlayerMP playerMP, long persistentId, MerchantOffer offer) {
        MerchantProfile profile;
        if (MerchantsConfig.ALLOW_MANAGEMENT_INGAME.asBoolean() && (profile = this.manager.getMerchantProfilesContainer().getProfileByPersistentId(persistentId)) != null) {
            profile.addOffer(offer);
            this.updateProfileId(profile);
            if (playerMP != null) {
                this.manager.sendStatusMessage(playerMP, EnumMerchantsStatusMessage.PROFILE_UPDATED);
            }
            return true;
        }
        return false;
    }

    public boolean removeMerchantOffer(@Nullable EntityPlayerMP playerMP, long persistentId, long offerId) {
        MerchantProfile profile;
        if (MerchantsConfig.ALLOW_MANAGEMENT_INGAME.asBoolean() && (profile = this.manager.getMerchantProfilesContainer().getProfileByPersistentId(persistentId)) != null) {
            profile.removeOffer(offerId);
            this.updateProfileId(profile);
            if (playerMP != null) {
                this.manager.sendStatusMessage(playerMP, EnumMerchantsStatusMessage.PROFILE_UPDATED);
            }
            return true;
        }
        return false;
    }

    public boolean saveProfile(@Nullable EntityPlayerMP playerMP, long persistentId) {
        MerchantProfile profile;
        if (MerchantsConfig.ALLOW_MANAGEMENT_INGAME.asBoolean() && (profile = this.manager.getMerchantProfilesContainer().getProfileByPersistentId(persistentId)) != null) {
            this.manager.getMerchantProfilesContainer().saveProfileAsync(persistentId);
            if (playerMP != null) {
                this.manager.sendStatusMessage(playerMP, EnumMerchantsStatusMessage.PROFILE_SAVED);
            }
            return true;
        }
        return false;
    }

    public boolean removeProfile(@Nullable EntityPlayerMP playerMP, long persistentId) {
        MerchantProfile profile;
        if (MerchantsConfig.ALLOW_MANAGEMENT_INGAME.asBoolean() && (profile = this.manager.getMerchantProfilesContainer().getProfileByPersistentId(persistentId)) != null) {
            this.manager.getMerchantProfilesContainer().removeProfileFileAsync(persistentId);
            this.manager.getMerchantProfilesContainer().removeProfile(persistentId);
            if (playerMP != null) {
                this.manager.sendStatusMessage(playerMP, EnumMerchantsStatusMessage.PROFILE_REMOVED);
            }
            return true;
        }
        return false;
    }
}

