/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.common.merchant;

import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.persistent.PersistentEntry;
import austeretony.oxygen_core.common.sync.SynchronousEntry;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_merchants.common.merchant.MerchantOffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class MerchantProfile
implements PersistentEntry,
SynchronousEntry {
    public static final int MAX_PROFILE_NAME_LENGTH = 24;
    private long persistentId;
    private long versionId;
    private String fileName;
    private String displayName;
    private int currencyIndex;
    private ItemStackWrapper currencyStackWrapper = ItemStackWrapper.of((ItemStack)new ItemStack(Items.field_190931_a));
    private final Map<Long, MerchantOffer> offers = new ConcurrentHashMap<Long, MerchantOffer>();

    public MerchantProfile() {
    }

    public MerchantProfile(long persistentiId, String fileName, String displayName) {
        this.persistentId = persistentiId;
        this.fileName = fileName;
        this.displayName = displayName;
    }

    public long getId() {
        return this.versionId;
    }

    public void setId(long profileId) {
        this.versionId = profileId;
    }

    public long getPersistentId() {
        return this.persistentId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public boolean isUsingVirtalCurrency() {
        return this.currencyIndex != -1;
    }

    public int getCurrencyIndex() {
        return this.currencyIndex;
    }

    public void setCurrencyIndex(int currencyIndex) {
        this.currencyIndex = currencyIndex;
    }

    @Nonnull
    public ItemStackWrapper getCurrencyStackWrapper() {
        return this.currencyStackWrapper;
    }

    public void setCurrencyStack(ItemStackWrapper currencyStack) {
        this.currencyStackWrapper = currencyStack;
        this.currencyIndex = -1;
    }

    public Collection<MerchantOffer> getOffers() {
        return this.offers.values();
    }

    public int getOffersAmount() {
        return this.offers.size();
    }

    public int getBuyOffersAmount() {
        int amount = 0;
        for (MerchantOffer offer : this.getOffers()) {
            if (!offer.isBuyEnabled()) continue;
            ++amount;
        }
        return amount;
    }

    public int getSellingOffersAmount() {
        int amount = 0;
        for (MerchantOffer offer : this.getOffers()) {
            if (!offer.isSellingEnabled()) continue;
            ++amount;
        }
        return amount;
    }

    @Nullable
    public MerchantOffer getOffer(long offerId) {
        return this.offers.get(offerId);
    }

    public void addOffer(MerchantOffer offer) {
        this.offers.put(offer.getId(), offer);
    }

    public void removeOffer(long offerId) {
        this.offers.remove(offerId);
    }

    public static MerchantProfile fromJson(JsonObject jsonObject) {
        MerchantProfile profile = new MerchantProfile();
        profile.persistentId = jsonObject.get("persistent_id").getAsLong();
        profile.versionId = jsonObject.get("version_id").getAsLong();
        profile.displayName = jsonObject.get("display_name").getAsString();
        profile.currencyIndex = jsonObject.get("currency_index").getAsInt();
        profile.currencyStackWrapper = ItemStackWrapper.fromJson((JsonObject)jsonObject.get("currency_itemstack").getAsJsonObject());
        JsonArray offersArray = jsonObject.get("offers").getAsJsonArray();
        for (JsonElement element : offersArray) {
            profile.addOffer(MerchantOffer.fromJson(element.getAsJsonObject()));
        }
        return profile;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("persistent_id", (JsonElement)new JsonPrimitive((Number)this.persistentId));
        jsonObject.add("version_id", (JsonElement)new JsonPrimitive((Number)this.versionId));
        jsonObject.add("display_name", (JsonElement)new JsonPrimitive(this.displayName));
        jsonObject.add("currency_index", (JsonElement)new JsonPrimitive((Number)this.currencyIndex));
        jsonObject.add("currency_itemstack", (JsonElement)this.currencyStackWrapper.toJson());
        JsonArray offersArray = new JsonArray();
        this.getOffers().stream().sorted((o1, o2) -> o1.getId() < o2.getId() ? -1 : (o1.getId() > o2.getId() ? 1 : 0)).forEach(offer -> offersArray.add((JsonElement)offer.toJson()));
        jsonObject.add("offers", (JsonElement)offersArray);
        return jsonObject;
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((long)this.persistentId, (OutputStream)bos);
        StreamUtils.write((long)this.versionId, (OutputStream)bos);
        StreamUtils.write((String)this.displayName, (OutputStream)bos);
        StreamUtils.write((String)this.fileName, (OutputStream)bos);
        StreamUtils.write((byte)((byte)this.currencyIndex), (OutputStream)bos);
        this.currencyStackWrapper.write(bos);
        StreamUtils.write((short)((short)this.offers.size()), (OutputStream)bos);
        for (MerchantOffer offer : this.offers.values()) {
            offer.write(bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.persistentId = StreamUtils.readLong((InputStream)bis);
        this.versionId = StreamUtils.readLong((InputStream)bis);
        this.displayName = StreamUtils.readString((InputStream)bis);
        this.fileName = StreamUtils.readString((InputStream)bis);
        this.currencyIndex = StreamUtils.readByte((InputStream)bis);
        this.currencyStackWrapper = ItemStackWrapper.read((BufferedInputStream)bis);
        int amount = StreamUtils.readShort((InputStream)bis);
        for (int i = 0; i < amount; ++i) {
            this.addOffer(MerchantOffer.read(bis));
        }
    }

    public void write(ByteBuf buffer) {
        buffer.writeLong(this.persistentId);
        buffer.writeLong(this.versionId);
        ByteBufUtils.writeString((String)this.displayName, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.fileName, (ByteBuf)buffer);
        buffer.writeByte(this.currencyIndex);
        this.currencyStackWrapper.write(buffer);
        buffer.writeShort(this.offers.size());
        for (MerchantOffer offer : this.offers.values()) {
            offer.write(buffer);
        }
    }

    public void read(ByteBuf buffer) {
        this.persistentId = buffer.readLong();
        this.versionId = buffer.readLong();
        this.displayName = ByteBufUtils.readString((ByteBuf)buffer);
        this.fileName = ByteBufUtils.readString((ByteBuf)buffer);
        this.currencyIndex = buffer.readByte();
        this.currencyStackWrapper = ItemStackWrapper.read((ByteBuf)buffer);
        int amount = buffer.readShort();
        for (int i = 0; i < amount; ++i) {
            this.addOffer(MerchantOffer.read(buffer));
        }
    }

    public MerchantProfile copy() {
        MerchantProfile profile = new MerchantProfile();
        profile.persistentId = this.persistentId;
        profile.versionId = this.versionId;
        profile.displayName = this.displayName;
        profile.fileName = this.fileName;
        profile.currencyIndex = this.currencyIndex;
        profile.currencyStackWrapper = this.currencyStackWrapper.copy();
        for (MerchantOffer offer : this.getOffers()) {
            this.addOffer(offer.copy());
        }
        return profile;
    }
}

