/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.common.merchant;

import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MerchantOffer {
    private final long id;
    private ItemStackWrapper stackWrapper;
    private int amount;
    private long buyCost;
    private long sellingCost;

    public MerchantOffer(long offerId, ItemStackWrapper offeredStack, int amount, long buyCost, long sellingCost) {
        this.id = offerId;
        this.stackWrapper = offeredStack;
        this.amount = amount;
        this.buyCost = buyCost;
        this.sellingCost = sellingCost;
    }

    public long getId() {
        return this.id;
    }

    public ItemStackWrapper getStackWrapper() {
        return this.stackWrapper;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isBuyEnabled() {
        return this.buyCost != 0L;
    }

    public long getBuyCost() {
        return this.buyCost;
    }

    public void setBuyCost(long value) {
        this.buyCost = MathUtils.clamp((long)value, (long)0L, (long)Long.MAX_VALUE);
    }

    public boolean isSellingEnabled() {
        return this.sellingCost != 0L;
    }

    public long getSellingCost() {
        return this.sellingCost;
    }

    public void setSellingCost(long value) {
        this.sellingCost = MathUtils.clamp((long)value, (long)0L, (long)Long.MAX_VALUE);
    }

    public String toString() {
        return String.format("[id: %d, itemstack: %s, amount: %d, buy cost: %d, selling cost: %d]", this.id, this.stackWrapper, this.amount, this.buyCost, this.sellingCost);
    }

    public static MerchantOffer fromJson(JsonObject jsonObject) {
        MerchantOffer offer = new MerchantOffer(jsonObject.get("id").getAsLong(), ItemStackWrapper.fromJson((JsonObject)jsonObject.get("itemstack").getAsJsonObject()), jsonObject.get("amount").getAsInt(), jsonObject.get("buy_cost").getAsLong(), jsonObject.get("selling_cost").getAsLong());
        return offer;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("id", (JsonElement)new JsonPrimitive((Number)this.id));
        jsonObject.add("amount", (JsonElement)new JsonPrimitive((Number)this.amount));
        jsonObject.add("buy_cost", (JsonElement)new JsonPrimitive((Number)this.buyCost));
        jsonObject.add("selling_cost", (JsonElement)new JsonPrimitive((Number)this.sellingCost));
        jsonObject.add("itemstack", (JsonElement)this.stackWrapper.toJson());
        return jsonObject;
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((long)this.id, (OutputStream)bos);
        this.stackWrapper.write(bos);
        StreamUtils.write((short)((short)this.amount), (OutputStream)bos);
        StreamUtils.write((long)this.buyCost, (OutputStream)bos);
        StreamUtils.write((long)this.sellingCost, (OutputStream)bos);
    }

    public static MerchantOffer read(BufferedInputStream bis) throws IOException {
        MerchantOffer offer = new MerchantOffer(StreamUtils.readLong((InputStream)bis), ItemStackWrapper.read((BufferedInputStream)bis), StreamUtils.readShort((InputStream)bis), StreamUtils.readLong((InputStream)bis), StreamUtils.readLong((InputStream)bis));
        return offer;
    }

    public void write(ByteBuf buffer) {
        buffer.writeLong(this.id);
        this.stackWrapper.write(buffer);
        buffer.writeShort((int)((short)this.amount));
        buffer.writeLong(this.buyCost);
        buffer.writeLong(this.sellingCost);
    }

    public static MerchantOffer read(ByteBuf buffer) {
        MerchantOffer offer = new MerchantOffer(buffer.readLong(), ItemStackWrapper.read((ByteBuf)buffer), buffer.readShort(), buffer.readLong(), buffer.readLong());
        return offer;
    }

    public MerchantOffer copy() {
        MerchantOffer offer = new MerchantOffer(this.id, this.stackWrapper.copy(), this.amount, this.buyCost, this.sellingCost);
        return offer;
    }
}

