/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.merchant;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.api.WatcherHelperClient;
import austeretony.oxygen_core.client.gui.elements.OxygenCurrencyValue;
import austeretony.oxygen_core.client.gui.elements.OxygenInventoryLoad;
import austeretony.oxygen_core.client.gui.elements.OxygenScrollablePanel;
import austeretony.oxygen_core.client.gui.elements.OxygenSectionSwitcher;
import austeretony.oxygen_core.client.gui.elements.OxygenSorter;
import austeretony.oxygen_core.client.gui.elements.OxygenTextLabel;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_merchants.client.MerchantsManagerClient;
import austeretony.oxygen_merchants.client.gui.merchant.BuyBackgroundFiller;
import austeretony.oxygen_merchants.client.gui.merchant.MerchantOfferPanelEntry;
import austeretony.oxygen_merchants.client.gui.merchant.MerchantScreen;
import austeretony.oxygen_merchants.common.merchant.MerchantOffer;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.item.ItemStack;

public class SellingSection
extends AbstractGUISection {
    private final MerchantScreen screen;
    private OxygenSorter nameSorter;
    private OxygenSorter priceSorter;
    private OxygenScrollablePanel offersPanel;
    private OxygenInventoryLoad inventoryLoad;
    private OxygenCurrencyValue balanceValue;

    public SellingSection(MerchantScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
        this.setDisplayText(ClientReference.localize((String)"oxygen_merchants.gui.merchant.selling", (Object[])new Object[0]));
    }

    public void init() {
        this.addElement((GUIBaseElement)new BuyBackgroundFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenTextLabel(4, 12, this.screen.getMerchantProfile().getDisplayName(), EnumBaseGUISetting.TEXT_TITLE_SCALE.get().asFloat(), EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt()));
        if (this.screen.debug) {
            this.addElement((GUIBaseElement)new OxygenTextLabel(40, this.getHeight() - 7, String.format("Persistent Id: %d", this.screen.getMerchantProfile().getPersistentId()), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.1f, EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt()));
            this.addElement((GUIBaseElement)new OxygenTextLabel(40, this.getHeight() - 1, String.format("File: %s", this.screen.getMerchantProfile().getFileName()), EnumBaseGUISetting.TEXT_SUB_SCALE.get().asFloat() - 0.1f, EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt()));
        }
        this.priceSorter = new OxygenSorter(6, 18, OxygenSorter.EnumSorting.INACTIVE, ClientReference.localize((String)"oxygen_core.gui.price", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.priceSorter);
        this.priceSorter.setSortingListener(sorting -> {
            this.nameSorter.reset();
            if (sorting == OxygenSorter.EnumSorting.DOWN) {
                this.loadOffers(1);
            } else {
                this.loadOffers(2);
            }
        });
        this.nameSorter = new OxygenSorter(12, 18, OxygenSorter.EnumSorting.INACTIVE, ClientReference.localize((String)"oxygen_core.gui.name", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.nameSorter);
        this.nameSorter.setSortingListener(sorting -> {
            this.priceSorter.reset();
            if (sorting == OxygenSorter.EnumSorting.DOWN) {
                this.loadOffers(3);
            } else {
                this.loadOffers(4);
            }
        });
        this.offersPanel = new OxygenScrollablePanel((AbstractGUIScreen)this.screen, 6, 24, this.getWidth() - 15, 16, 1, MathUtils.clamp((int)this.screen.sellingOffersAmount, (int)9, (int)100), 9, EnumBaseGUISetting.TEXT_PANEL_SCALE.get().asFloat(), true);
        this.addElement((GUIBaseElement)this.offersPanel);
        this.offersPanel.setElementClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0 && clicked.isAvailable()) {
                MerchantsManagerClient.instance().getMenuManager().performSellingSynced((Long)clicked.getWrapped());
            }
        });
        this.addElement((GUIBaseElement)new OxygenSectionSwitcher(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getBuySection()}));
        this.balanceValue = new OxygenCurrencyValue(this.getWidth() - 14, this.getHeight() - 10);
        this.addElement((GUIBaseElement)this.balanceValue);
        this.updateBalance();
        this.inventoryLoad = new OxygenInventoryLoad(6, this.getHeight() - 8);
        this.addElement((GUIBaseElement)this.inventoryLoad);
        this.inventoryLoad.setLoad(this.screen.getBuySection().getInventoryLoad().getLoad());
        this.loadOffers(0);
    }

    private void updateBalance() {
        long balance = 0L;
        if (this.screen.getMerchantProfile().isUsingVirtalCurrency()) {
            balance = WatcherHelperClient.getLong((int)this.screen.getMerchantProfile().getCurrencyIndex());
            this.balanceValue.setValue(this.screen.getMerchantProfile().getCurrencyIndex(), balance);
        } else {
            balance = this.screen.getEqualStackAmount(this.screen.getMerchantProfile().getCurrencyStackWrapper());
            this.balanceValue.setValue(this.screen.getMerchantProfile().getCurrencyStackWrapper().getCachedItemStack(), (int)balance);
        }
        this.balanceValue.setRed(balance == 0L);
    }

    private void loadOffers(int mode) {
        ArrayList<MerchantOffer> offers = new ArrayList<MerchantOffer>(this.screen.getMerchantProfile().getOffers());
        if (mode == 0) {
            Collections.sort(offers, (o1, o2) -> o1.getId() < o2.getId() ? -1 : (o1.getId() > o2.getId() ? 1 : 0));
        } else if (mode == 1) {
            Collections.sort(offers, (o1, o2) -> o1.getSellingCost() < o2.getSellingCost() ? -1 : (o1.getSellingCost() > o2.getSellingCost() ? 1 : 0));
        } else if (mode == 2) {
            Collections.sort(offers, (o1, o2) -> o2.getSellingCost() < o1.getSellingCost() ? -1 : (o2.getSellingCost() > o1.getSellingCost() ? 1 : 0));
        } else if (mode == 3) {
            Collections.sort(offers, (o1, o2) -> SellingSection.getItemDisplayName(o1).compareTo(SellingSection.getItemDisplayName(o2)));
        } else if (mode == 4) {
            Collections.sort(offers, (o1, o2) -> SellingSection.getItemDisplayName(o2).compareTo(SellingSection.getItemDisplayName(o1)));
        }
        ItemStack currencyStack = null;
        if (!this.screen.getMerchantProfile().isUsingVirtalCurrency()) {
            currencyStack = this.screen.getMerchantProfile().getCurrencyStackWrapper().getCachedItemStack();
        }
        this.offersPanel.reset();
        for (MerchantOffer offer : offers) {
            if (!offer.isSellingEnabled()) continue;
            int stock = this.screen.getEqualStackAmount(offer.getStackWrapper());
            this.offersPanel.addEntry((GUIButton)new MerchantOfferPanelEntry(offer, offer.getSellingCost(), this.screen.getEqualStackAmount(offer.getStackWrapper()), currencyStack, this.screen.getCurrencyProperties(), this.screen.debug).setAvailable((this.screen.getMerchantProfile().isUsingVirtalCurrency() || !this.inventoryLoad.isOverloaded()) && stock >= offer.getAmount()));
        }
        this.offersPanel.getScroller().updateRowsAmount(MathUtils.clamp((int)offers.size(), (int)9, (int)this.screen.sellingOffersAmount));
    }

    public static String getItemDisplayName(MerchantOffer offer) {
        return offer.getStackWrapper().getCachedItemStack().func_82833_r();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
    }

    public void bought(MerchantOffer offer, long balance) {
        this.balanceValue.updateValue(balance);
        this.balanceValue.setRed(balance == 0L);
        this.inventoryLoad.setLoad(this.screen.getBuySection().getInventoryLoad().getLoad());
        this.updateOffers();
    }

    private void updateOffers() {
        for (GUIButton button : this.offersPanel.buttonsBuffer) {
            MerchantOfferPanelEntry offerButton = (MerchantOfferPanelEntry)button;
            MerchantOffer offer = this.screen.getMerchantProfile().getOffer((Long)offerButton.getWrapped());
            int stock = this.screen.getEqualStackAmount(offer.getStackWrapper());
            offerButton.setAvailable((this.screen.getMerchantProfile().isUsingVirtalCurrency() || !this.inventoryLoad.isOverloaded()) && stock >= offer.getAmount());
            offerButton.setPlayerStock(stock);
        }
    }

    public void sold(MerchantOffer offer, long balance) {
        this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.INVENTORY_OPERATION.getSoundEvent(), 0.5f, 1.0f);
        this.mc.field_71439_g.func_184185_a(OxygenSoundEffects.RINGING_COINS.getSoundEvent(), 0.5f, 1.0f);
        this.balanceValue.updateValue(balance);
        this.balanceValue.setRed(balance == 0L);
        this.inventoryLoad.setLoad(this.screen.getBuySection().getInventoryLoad().getLoad());
        this.updateOffers();
    }
}

