/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_merchants.client.gui.merchant;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.EnumBaseClientSetting;
import austeretony.oxygen_core.client.api.EnumBaseGUISetting;
import austeretony.oxygen_core.client.currency.CurrencyProperties;
import austeretony.oxygen_core.client.gui.ItemRenderHelper;
import austeretony.oxygen_core.client.gui.OxygenGUIUtils;
import austeretony.oxygen_core.client.gui.elements.OxygenWrapperPanelEntry;
import austeretony.oxygen_core.common.util.OxygenUtils;
import austeretony.oxygen_merchants.common.merchant.MerchantOffer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class MerchantOfferPanelEntry
extends OxygenWrapperPanelEntry<Long> {
    private final ItemStack offeredStack;
    private final ItemStack currencyStack;
    private final String idStr;
    private final String amountStr;
    private final String costStr;
    private String playerStockStr;
    private final boolean singleItem;
    private final boolean enableDurabilityBar;
    private final boolean debug;
    private boolean useCurrencyStack;
    private boolean available;
    private CurrencyProperties currencyProperties;

    public MerchantOfferPanelEntry(MerchantOffer offer, long cost, int playerStock, ItemStack currencyStack, CurrencyProperties properties, boolean debug) {
        super((Object)offer.getId());
        this.playerStockStr = String.valueOf(playerStock);
        this.offeredStack = offer.getStackWrapper().getCachedItemStack();
        this.currencyStack = currencyStack;
        this.useCurrencyStack = currencyStack != null;
        this.idStr = String.format("Id: %d", offer.getId());
        this.amountStr = String.valueOf(offer.getAmount());
        this.costStr = OxygenUtils.formatCurrencyValue((String)String.valueOf(cost));
        this.singleItem = offer.getAmount() == 1;
        this.currencyProperties = properties;
        this.debug = debug;
        this.enableDurabilityBar = EnumBaseClientSetting.ENABLE_ITEMS_DURABILITY_BAR.get().asBoolean();
        this.setDisplayText(EnumBaseClientSetting.ENABLE_RARITY_COLORS.get().asBoolean() ? this.offeredStack.func_77953_t().field_77937_e + this.offeredStack.func_82833_r() : this.offeredStack.func_82833_r());
        this.setDynamicBackgroundColor(EnumBaseGUISetting.ELEMENT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.ELEMENT_HOVERED_COLOR.get().asInt());
        this.setTextDynamicColor(EnumBaseGUISetting.TEXT_ENABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_DISABLED_COLOR.get().asInt(), EnumBaseGUISetting.TEXT_HOVERED_COLOR.get().asInt());
        this.setDebugColor(EnumBaseGUISetting.INACTIVE_ELEMENT_COLOR.get().asInt());
        this.setStaticBackgroundColor(EnumBaseGUISetting.TEXT_DARK_ENABLED_COLOR.get().asInt());
        this.requireDoubleClick();
    }

    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179126_j();
            this.itemRender.func_180450_b(this.offeredStack, this.getX() + 2, this.getY());
            if (this.enableDurabilityBar) {
                FontRenderer font = this.offeredStack.func_77973_b().getFontRenderer(this.offeredStack);
                if (font == null) {
                    font = this.mc.field_71466_p;
                }
                this.itemRender.func_180453_a(font, this.offeredStack, this.getX() + 2, this.getY(), null);
            }
            GlStateManager.func_179097_i();
            RenderHelper.func_74518_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = this.getEnabledBackgroundColor();
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
            } else if (this.isHovered()) {
                color = this.getHoveredBackgroundColor();
            }
            int third = this.getWidth() / 3;
            OxygenGUIUtils.drawGradientRect((double)0.0, (double)0.0, (double)third, (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.RIGHT);
            MerchantOfferPanelEntry.drawRect((int)third, (int)0, (int)(this.getWidth() - third), (int)this.getHeight(), (int)color);
            OxygenGUIUtils.drawGradientRect((double)(this.getWidth() - third), (double)0.0, (double)this.getWidth(), (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.LEFT);
            color = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                color = this.getDisabledTextColor();
            } else if (this.isHovered()) {
                color = this.getHoveredTextColor();
            }
            if (this.isHovered()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)16.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(this.getTextScale() - 0.05f), (float)(this.getTextScale() - 0.05f), (float)0.0f);
                this.mc.field_71466_p.func_175065_a(this.playerStockStr, 0.0f, 0.0f, color, true);
                GlStateManager.func_179121_F();
            }
            if (!this.singleItem) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)16.0f, (float)10.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(this.getTextScale() - 0.05f), (float)(this.getTextScale() - 0.05f), (float)0.0f);
                this.mc.field_71466_p.func_175065_a(this.amountStr, 0.0f, 0.0f, color, true);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.getWidth() - 12.0f - (float)this.textWidth(this.costStr, this.getTextScale() - 0.05f)), (float)((float)(this.getHeight() - this.textHeight(this.getTextScale() - 0.05f)) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)(this.getTextScale() - 0.05f), (float)(this.getTextScale() - 0.05f), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.costStr, 0.0f, 0.0f, this.available ? color : -3407872, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)28.0f, (float)((float)(this.getHeight() - this.textHeight(this.getTextScale() + 0.05f)) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)(this.getTextScale() + 0.05f), (float)(this.getTextScale() + 0.05f), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, this.available ? color : this.getDebugColor(), false);
            GlStateManager.func_179121_F();
            if (this.debug) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)110.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(this.getTextScale() - 0.1f), (float)(this.getTextScale() - 0.1f), (float)0.0f);
                this.mc.field_71466_p.func_175065_a(this.idStr, 0.0f, 0.0f, this.getStaticBackgroundColor(), false);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.useCurrencyStack) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.getWidth() - 10.0f), (float)4.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                RenderHelper.func_74520_c();
                GlStateManager.func_179126_j();
                ItemRenderHelper.renderItemWithoutEffectIntoGUI((ItemStack)this.currencyStack, (int)0, (int)0);
                GlStateManager.func_179097_i();
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            } else {
                GlStateManager.func_179147_l();
                this.mc.func_110434_K().func_110577_a(this.currencyProperties.getIcon());
                GUIAdvancedElement.drawCustomSizedTexturedRect((int)(this.getWidth() - 10 + this.currencyProperties.getXOffset()), (int)((this.getHeight() - this.currencyProperties.getIconHeight()) / 2 + this.currencyProperties.getYOffset()), (int)0, (int)0, (int)this.currencyProperties.getIconWidth(), (int)this.currencyProperties.getIconHeight(), (int)this.currencyProperties.getIconWidth(), (int)this.currencyProperties.getIconHeight());
                GlStateManager.func_179084_k();
            }
            GlStateManager.func_179121_F();
        }
    }

    public void drawTooltip(int mouseX, int mouseY) {
        if (mouseX >= this.getX() + 2 && mouseY >= this.getY() && mouseX < this.getX() + 18 && mouseY < this.getY() + this.getHeight()) {
            this.screen.drawToolTip(this.offeredStack, mouseX + 6, mouseY);
        }
    }

    public void setPlayerStock(int value) {
        this.playerStockStr = String.valueOf(value);
    }

    public ItemStack getOfferedStack() {
        return this.offeredStack;
    }

    public MerchantOfferPanelEntry setAvailable(boolean flag) {
        this.available = flag;
        if (flag) {
            this.setDisplayText(EnumBaseClientSetting.ENABLE_RARITY_COLORS.get().asBoolean() ? this.offeredStack.func_77953_t().field_77937_e + this.offeredStack.func_82833_r() : this.offeredStack.func_82833_r());
        } else {
            this.setDisplayText(this.offeredStack.func_82833_r());
        }
        return this;
    }

    public boolean isAvailable() {
        return this.available;
    }
}

