/*
 * Decompiled with CFR 0.152.
 */
package net.craftzbolezni.gui.overlay;

import net.craftzbolezni.ElementsCraftzbolezniMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsCraftzbolezniMod.ModElement.Tag
public class OverlayOverlaySoundIndicator
extends ElementsCraftzbolezniMod.ModElement {
    public OverlayOverlaySoundIndicator(ElementsCraftzbolezniMod instance) {
        super(instance, 147);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new GUIRenderEventClass());
    }

    @SideOnly(value=Side.CLIENT)
    public static class GUIRenderEventClass {
        private static int soundLevel = 0;
        private static final int MAX_SOUND_LEVEL = 100;

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && soundLevel > 0 && (soundLevel = (int)((double)soundLevel - 1.5)) < 0) {
                soundLevel = 0;
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onPlaySound(PlaySoundEvent event) {
            if (event.getSound() != null && event.getSound().func_184365_d() == SoundCategory.PLAYERS && soundLevel < 100 && (soundLevel += 35) > 100) {
                soundLevel = 100;
            }
        }

        @SubscribeEvent(priority=EventPriority.NORMAL)
        @SideOnly(value=Side.CLIENT)
        public void eventHandler(RenderGameOverlayEvent event) {
            if (!event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.HELMET) {
                return;
            }
            String texture = GUIRenderEventClass.getTextureBySoundLevel();
            GUIRenderEventClass.renderIcon(event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), texture);
        }

        private static String getTextureBySoundLevel() {
            if (soundLevel >= 100) {
                return "craftzbolezni:textures/uho5.png";
            }
            if (soundLevel >= 80) {
                return "craftzbolezni:textures/uho4.png";
            }
            if (soundLevel >= 60) {
                return "craftzbolezni:textures/uho3.png";
            }
            if (soundLevel >= 40) {
                return "craftzbolezni:textures/uho2.png";
            }
            if (soundLevel >= 20) {
                return "craftzbolezni:textures/uho1.png";
            }
            return "craftzbolezni:textures/uho0.png";
        }

        @SideOnly(value=Side.CLIENT)
        private static void renderIcon(int screenWidth, int screenHeight, String texturePath) {
            int iconWidth = 54;
            int iconHeight = 24;
            int hotbarWidth = 182;
            int iconOffsetFromHotbar = 215;
            int hotbarOffsetY = 1;
            int posX = screenWidth / 2 + hotbarWidth / 2 - iconOffsetFromHotbar - iconWidth;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && !player.func_184592_cb().func_190926_b()) {
                posX -= 27;
            }
            int posY = screenHeight - iconHeight - hotbarOffsetY;
            GlStateManager.func_179094_E();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(texturePath));
            GuiIngame cfr_ignored_0 = Minecraft.func_71410_x().field_71456_v;
            GuiIngame.func_146110_a((int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)iconWidth, (int)iconHeight, (float)iconWidth, (float)iconHeight);
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }
}

