/*
 * Decompiled with CFR 0.152.
 */
package net.craftzbolezni.gui.overlay;

import net.craftzbolezni.ElementsCraftzbolezniMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsCraftzbolezniMod.ModElement.Tag
public class OverlayArmor
extends ElementsCraftzbolezniMod.ModElement {
    public OverlayArmor(ElementsCraftzbolezniMod instance) {
        super(instance, 129);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new GUIRenderEventClass());
    }

    public static class GUIRenderEventClass {
        @SubscribeEvent(priority=EventPriority.NORMAL)
        @SideOnly(value=Side.CLIENT)
        public void eventHandler(RenderGameOverlayEvent event) {
            if (!event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.HELMET) {
                return;
            }
            EntityPlayerSP entity = Minecraft.func_71410_x().field_71439_g;
            if (entity == null) {
                return;
            }
            int totalDisplayArmor = 0;
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = (ItemStack)entity.field_71071_by.field_70460_b.get(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArmor)) continue;
                ItemArmor armorItem = (ItemArmor)stack.func_77973_b();
                if (armorItem instanceof ISpecialArmor) {
                    ISpecialArmor specialArmor = (ISpecialArmor)armorItem;
                    totalDisplayArmor += specialArmor.getArmorDisplay((EntityPlayer)entity, stack, i);
                    continue;
                }
                int armorValue = armorItem.field_77879_b;
                totalDisplayArmor += armorValue * 1;
            }
            int armorLevel = totalDisplayArmor;
            int screenWidth = event.getResolution().func_78326_a();
            int screenHeight = event.getResolution().func_78328_b();
            if (armorLevel >= 20) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor1.png");
            } else if (armorLevel >= 18) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor2.png");
            } else if (armorLevel >= 16) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor3.png");
            } else if (armorLevel >= 14) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor4.png");
            } else if (armorLevel >= 12) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor5.png");
            } else if (armorLevel >= 10) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor6.png");
            } else if (armorLevel >= 8) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor7.png");
            } else if (armorLevel >= 6) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor8.png");
            } else if (armorLevel >= 4) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor9.png");
            } else if (armorLevel >= 2) {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor10.png");
            } else {
                GUIRenderEventClass.renderIcon(screenWidth, screenHeight, "craftzbolezni:textures/armor11.png");
            }
        }

        @SideOnly(value=Side.CLIENT)
        private static void renderIcon(int screenWidth, int screenHeight, String texturePath) {
            int iconWidth = 27;
            int iconHeight = 24;
            int hotbarWidth = 182;
            int iconOffsetFromHotbar = 185;
            int hotbarOffsetY = 1;
            int posX = screenWidth / 2 + hotbarWidth / 2 - iconOffsetFromHotbar - iconWidth;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && !player.func_184592_cb().func_190926_b()) {
                posX -= 27;
            }
            int posY = screenHeight - iconHeight - hotbarOffsetY;
            GlStateManager.func_179094_E();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(texturePath));
            GuiIngame cfr_ignored_0 = Minecraft.func_71410_x().field_71456_v;
            GuiIngame.func_146110_a((int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)iconWidth, (int)iconHeight, (float)iconWidth, (float)iconHeight);
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }
}

