/*
 * Decompiled with CFR 0.152.
 */
package net.craftzbolezni;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.craftzbolezni.CraftzbolezniMod;
import net.craftzbolezni.CraftzbolezniModVariables;
import net.craftzbolezni.gui.GuiGitargui;
import net.craftzbolezni.gui.GuiRemont;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;

public class ElementsCraftzbolezniMod
implements IFuelHandler,
IWorldGenerator {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityEntry>> entities = new ArrayList<Supplier<EntityEntry>>();
    public final List<Supplier<Potion>> potions = new ArrayList<Supplier<Potion>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public ElementsCraftzbolezniMod() {
        sounds.put(new ResourceLocation("craftzbolezni", "brutalik"), new SoundEvent(new ResourceLocation("craftzbolezni", "brutalik")));
        sounds.put(new ResourceLocation("craftzbolezni", "tabletki"), new SoundEvent(new ResourceLocation("craftzbolezni", "tabletki")));
        sounds.put(new ResourceLocation("craftzbolezni", "kashel"), new SoundEvent(new ResourceLocation("craftzbolezni", "kashel")));
        sounds.put(new ResourceLocation("craftzbolezni", "isterika"), new SoundEvent(new ResourceLocation("craftzbolezni", "isterika")));
        sounds.put(new ResourceLocation("craftzbolezni", "kopie"), new SoundEvent(new ResourceLocation("craftzbolezni", "kopie")));
        sounds.put(new ResourceLocation("craftzbolezni", "kopieotskok"), new SoundEvent(new ResourceLocation("craftzbolezni", "kopieotskok")));
        sounds.put(new ResourceLocation("craftzbolezni", "sprich"), new SoundEvent(new ResourceLocation("craftzbolezni", "sprich")));
        sounds.put(new ResourceLocation("craftzbolezni", "adrenaline"), new SoundEvent(new ResourceLocation("craftzbolezni", "adrenaline")));
        sounds.put(new ResourceLocation("craftzbolezni", "woterpump"), new SoundEvent(new ResourceLocation("craftzbolezni", "woterpump")));
        sounds.put(new ResourceLocation("craftzbolezni", "sveynaya"), new SoundEvent(new ResourceLocation("craftzbolezni", "sveynaya")));
        sounds.put(new ResourceLocation("craftzbolezni", "boxopen"), new SoundEvent(new ResourceLocation("craftzbolezni", "boxopen")));
        sounds.put(new ResourceLocation("craftzbolezni", "odejda"), new SoundEvent(new ResourceLocation("craftzbolezni", "odejda")));
        sounds.put(new ResourceLocation("craftzbolezni", "vodkadrink"), new SoundEvent(new ResourceLocation("craftzbolezni", "vodkadrink")));
        sounds.put(new ResourceLocation("craftzbolezni", "poxmelie"), new SoundEvent(new ResourceLocation("craftzbolezni", "poxmelie")));
        sounds.put(new ResourceLocation("craftzbolezni", "gitarplay"), new SoundEvent(new ResourceLocation("craftzbolezni", "gitarplay")));
        sounds.put(new ResourceLocation("craftzbolezni", "sigaret"), new SoundEvent(new ResourceLocation("craftzbolezni", "sigaret")));
        sounds.put(new ResourceLocation("craftzbolezni", "petart"), new SoundEvent(new ResourceLocation("craftzbolezni", "petart")));
        sounds.put(new ResourceLocation("craftzbolezni", "activepetartd"), new SoundEvent(new ResourceLocation("craftzbolezni", "activepetartd")));
        sounds.put(new ResourceLocation("craftzbolezni", "banditatack"), new SoundEvent(new ResourceLocation("craftzbolezni", "banditatack")));
        sounds.put(new ResourceLocation("craftzbolezni", "banditdead"), new SoundEvent(new ResourceLocation("craftzbolezni", "banditdead")));
        sounds.put(new ResourceLocation("craftzbolezni", "bandithurt"), new SoundEvent(new ResourceLocation("craftzbolezni", "bandithurt")));
        sounds.put(new ResourceLocation("craftzbolezni", "banditidle"), new SoundEvent(new ResourceLocation("craftzbolezni", "banditidle")));
        sounds.put(new ResourceLocation("craftzbolezni", "boechattack"), new SoundEvent(new ResourceLocation("craftzbolezni", "boechattack")));
        sounds.put(new ResourceLocation("craftzbolezni", "boechdead"), new SoundEvent(new ResourceLocation("craftzbolezni", "boechdead")));
        sounds.put(new ResourceLocation("craftzbolezni", "boechhurt"), new SoundEvent(new ResourceLocation("craftzbolezni", "boechhurt")));
        sounds.put(new ResourceLocation("craftzbolezni", "boechidle"), new SoundEvent(new ResourceLocation("craftzbolezni", "boechidle")));
        sounds.put(new ResourceLocation("craftzbolezni", "handcuffs"), new SoundEvent(new ResourceLocation("craftzbolezni", "handcuffs")));
        sounds.put(new ResourceLocation("craftzbolezni", "potery"), new SoundEvent(new ResourceLocation("craftzbolezni", "potery")));
        sounds.put(new ResourceLocation("craftzbolezni", "zaraza"), new SoundEvent(new ResourceLocation("craftzbolezni", "zaraza")));
        sounds.put(new ResourceLocation("craftzbolezni", "raideover"), new SoundEvent(new ResourceLocation("craftzbolezni", "raideover")));
        sounds.put(new ResourceLocation("craftzbolezni", "ethan_angry"), new SoundEvent(new ResourceLocation("craftzbolezni", "ethan_angry")));
        sounds.put(new ResourceLocation("craftzbolezni", "ethan_hurt"), new SoundEvent(new ResourceLocation("craftzbolezni", "ethan_hurt")));
        sounds.put(new ResourceLocation("craftzbolezni", "ethan_ide"), new SoundEvent(new ResourceLocation("craftzbolezni", "ethan_ide")));
        sounds.put(new ResourceLocation("craftzbolezni", "pnv"), new SoundEvent(new ResourceLocation("craftzbolezni", "pnv")));
        sounds.put(new ResourceLocation("craftzbolezni", "skillhead"), new SoundEvent(new ResourceLocation("craftzbolezni", "skillhead")));
    }

    public void preInit(FMLPreInitializationEvent event) {
        try {
            for (ASMDataTable.ASMData asmData : event.getAsmData().getAll(ModElement.Tag.class.getName())) {
                Class<?> clazz = Class.forName(asmData.getClassName());
                if (clazz.getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        this.addNetworkMessage(CraftzbolezniModVariables.WorldSavedDataSyncMessageHandler.class, CraftzbolezniModVariables.WorldSavedDataSyncMessage.class, Side.SERVER, Side.CLIENT);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator cg, IChunkProvider cp) {
        this.elements.forEach(element -> element.generateWorld(random, chunkX * 16, chunkZ * 16, world, world.field_73011_w.getDimension(), cg, cp));
    }

    public int getBurnTime(ItemStack fuel) {
        for (ModElement element : this.elements) {
            int ret = element.addFuel(fuel);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            CraftzbolezniModVariables.MapVariables mapdata = CraftzbolezniModVariables.MapVariables.get(event.player.field_70170_p);
            CraftzbolezniModVariables.WorldVariables worlddata = CraftzbolezniModVariables.WorldVariables.get(event.player.field_70170_p);
            if (mapdata != null) {
                CraftzbolezniMod.PACKET_HANDLER.sendTo((IMessage)new CraftzbolezniModVariables.WorldSavedDataSyncMessage(0, mapdata), (EntityPlayerMP)event.player);
            }
            if (worlddata != null) {
                CraftzbolezniMod.PACKET_HANDLER.sendTo((IMessage)new CraftzbolezniModVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CraftzbolezniModVariables.WorldVariables worlddata;
        if (!event.player.field_70170_p.field_72995_K && (worlddata = CraftzbolezniModVariables.WorldVariables.get(event.player.field_70170_p)) != null) {
            CraftzbolezniMod.PACKET_HANDLER.sendTo((IMessage)new CraftzbolezniModVariables.WorldSavedDataSyncMessage(1, worlddata), (EntityPlayerMP)event.player);
        }
    }

    public <T extends IMessage, V extends IMessage> void addNetworkMessage(Class<? extends IMessageHandler<T, V>> handler, Class<T> messageClass, Side ... sides) {
        for (Side side : sides) {
            CraftzbolezniMod.PACKET_HANDLER.registerMessage(handler, messageClass, this.messageID, side);
        }
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityEntry>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Potion>> getPotions() {
        return this.potions;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final ElementsCraftzbolezniMod elements;
        protected final int sortid;

        public ModElement(ElementsCraftzbolezniMod elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLInitializationEvent event) {
        }

        public void preInit(FMLPreInitializationEvent event) {
        }

        public void generateWorld(Random random, int posX, int posZ, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        public void registerModels(ModelRegistryEvent event) {
        }

        public int addFuel(ItemStack fuel) {
            return 0;
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }

    public static class GuiHandler
    implements IGuiHandler {
        public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            if (id == GuiRemont.GUIID) {
                return new GuiRemont.GuiContainerMod(world, x, y, z, player);
            }
            if (id == GuiGitargui.GUIID) {
                return new GuiGitargui.GuiContainerMod(world, x, y, z, player);
            }
            return null;
        }

        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            if (id == GuiRemont.GUIID) {
                return new GuiRemont.GuiWindow(world, x, y, z, player);
            }
            if (id == GuiGitargui.GUIID) {
                return new GuiGitargui.GuiWindow(world, x, y, z, player);
            }
            return null;
        }
    }
}

