/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.items;

import com.google.common.base.Preconditions;
import com.teammetallurgy.aquaculture.loot.BiomeType;
import com.teammetallurgy.aquaculture.loot.FishLoot;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFish
extends Item {
    public NonNullList<Fish> fish;

    public ItemFish() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.fish = NonNullList.func_191196_a();
        this.func_77625_d(4);
    }

    public void addFish(String name, int filletAmount, int minWeight, int maxWeight, BiomeType biome, int rarity) {
        this.addFish(name, filletAmount, minWeight, maxWeight, new BiomeType[]{biome}, rarity);
    }

    public void addFish(String name, int filletAmount, int minWeight, int maxWeight, BiomeType[] biomes, int rarity) {
        this.fish.add((Object)new Fish(name, filletAmount, minWeight, maxWeight));
        for (BiomeType biome : biomes) {
            FishLoot.instance().addFish(this.getItemStackFish(name), biome, rarity);
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Prefix")) {
            return stack.func_77978_p().func_74779_i("Prefix") + " " + super.func_77653_i(stack);
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> toolTip, ITooltipFlag tooltipType) {
        if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Weight")) {
            float weight = stack.func_77978_p().func_74760_g("Weight");
            DecimalFormat df = new DecimalFormat("#,###.##");
            BigDecimal bd = new BigDecimal(weight);
            if ((bd = bd.round(new MathContext(3))).doubleValue() > 999.0) {
                toolTip.add("Weight: " + df.format((int)bd.doubleValue()) + "lb");
            } else {
                toolTip.add("Weight: " + bd + "lb");
            }
        }
    }

    public void assignRandomWeight(@Nonnull ItemStack stack, int heavyLineLvl) {
        if (stack.func_190926_b()) {
            return;
        }
        Fish f = (Fish)this.fish.get(stack.func_77952_i());
        if (f.maxWeight == 1 && f.minWeight == 1) {
            return;
        }
        float min = f.minWeight;
        min = (float)((double)min + (double)((float)f.maxWeight - min) * (0.1 * (double)heavyLineLvl));
        float weight = new Random().nextFloat() * ((float)f.maxWeight - min) + min;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        Preconditions.checkNotNull((Object)stack.func_77978_p(), (Object)"tagCompound");
        stack.func_77978_p().func_74776_a("Weight", weight);
        if (weight <= (float)f.maxWeight * 0.1f) {
            stack.func_77978_p().func_74778_a("Prefix", "Juvenile");
        } else if (weight > (float)f.maxWeight * 0.1f && weight <= (float)f.maxWeight * 0.2f) {
            stack.func_77978_p().func_74778_a("Prefix", "Small");
        } else if (weight >= (float)f.maxWeight * 0.8f && weight < (float)f.maxWeight * 0.9f) {
            stack.func_77978_p().func_74778_a("Prefix", "Large");
        } else if (weight >= (float)f.maxWeight * 0.9f) {
            stack.func_77978_p().func_74778_a("Prefix", "Massive");
        }
    }

    @Nonnull
    public ItemStack getItemStackFish(String name) {
        for (int i = 0; i < this.fish.size(); ++i) {
            if (!((Fish)this.fish.get((int)i)).name.equals(name)) continue;
            return new ItemStack((Item)this, 1, i);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)this.fish.size());
        String uname = super.func_77658_a() + "." + ((Fish)this.fish.get((int)i)).name;
        uname = uname.replace(" ", "_");
        return uname;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int j = 0; j < this.fish.size(); ++j) {
                subItems.add((Object)new ItemStack((Item)this, 1, j));
            }
        }
    }

    public class Fish {
        public String name;
        public int filletAmount;
        public int minWeight;
        public int maxWeight;

        public Fish(String name, int amount, int min, int max) {
            this.name = name;
            this.filletAmount = amount;
            this.maxWeight = max;
            this.minWeight = min;
        }
    }
}

