/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.handlers;

import com.teammetallurgy.aquaculture.enchantments.AquacultureEnchants;
import com.teammetallurgy.aquaculture.items.ItemAdminFishingRod;
import com.teammetallurgy.aquaculture.items.ItemAquacultureFishingRod;
import com.teammetallurgy.aquaculture.items.ItemFish;
import com.teammetallurgy.aquaculture.loot.FishLoot;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCustomFishHook
extends EntityFishHook
implements IThrowableEntity {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(EntityFishHook.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean inGround;
    private int ticksInGround;
    private EntityPlayer angler;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    public Entity field_146043_c;
    private State currentState = State.FLYING;
    private int luck;
    private int lureSpeed;
    private boolean isAdmin = false;

    @SideOnly(value=Side.CLIENT)
    public EntityCustomFishHook(World world, EntityPlayer player, double x, double y, double z) {
        super(world, player, x, y, z);
        this.init(player);
        this.func_70107_b(x, y, z);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public EntityCustomFishHook(World world, EntityPlayer player) {
        super(world, player);
        this.init(player);
        this.shoot();
        int shortCast = EnchantmentHelper.func_77506_a((Enchantment)AquacultureEnchants.shortcast, (ItemStack)player.func_184614_ca());
        int longCast = EnchantmentHelper.func_77506_a((Enchantment)AquacultureEnchants.longcast, (ItemStack)player.func_184614_ca());
        float velocity = 1.5f;
        if (shortCast > 0) {
            velocity *= 0.1f * (float)shortCast;
        }
        if (longCast > 0) {
            velocity += velocity * (0.2f * (float)longCast);
        }
        this.calculateVelocity(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 1.0f);
    }

    public EntityCustomFishHook(World world, EntityPlayer entityplayer, boolean isAdmin) {
        this(world, entityplayer);
        this.isAdmin = isAdmin;
    }

    public EntityCustomFishHook(World world) {
        this(world, null);
    }

    private void init(EntityPlayer p_190626_1_) {
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
        this.angler = p_190626_1_;
        this.angler.field_71104_cf = this;
    }

    public void func_191516_a(int speed) {
        this.lureSpeed = speed;
    }

    public void func_191517_b(int luck) {
        this.luck = luck;
    }

    private void shoot() {
        float f = this.angler.field_70127_C + (this.angler.field_70125_A - this.angler.field_70127_C);
        float f1 = this.angler.field_70126_B + (this.angler.field_70177_z - this.angler.field_70126_B);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        double d0 = this.angler.field_70169_q + (this.angler.field_70165_t - this.angler.field_70169_q) - (double)f3 * 0.3;
        double d1 = this.angler.field_70167_r + (this.angler.field_70163_u - this.angler.field_70167_r) + (double)this.angler.func_70047_e();
        double d2 = this.angler.field_70166_s + (this.angler.field_70161_v - this.angler.field_70166_s) - (double)f2 * 0.3;
        this.func_70012_b(d0, d1, d2, f1, f);
        this.field_70159_w = -f3;
        this.field_70181_x = MathHelper.func_76131_a((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f);
        this.field_70179_y = -f2;
        float f6 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70159_w *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        this.field_70181_x *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        this.field_70179_y *= 0.6 / (double)f6 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045;
        float f7 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f7) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void func_184206_a(@Nullable DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            this.field_146043_c = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70071_h_() {
        super.func_70030_z();
        if (this.angler == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() == Material.field_151586_h) {
                f = BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.field_146043_c != null) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.field_70159_w *= 0.3;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.3;
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (this.field_146043_c.field_70128_L) {
                            this.field_146043_c = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.field_70165_t = this.field_146043_c.field_70165_t;
                            double d2 = this.field_146043_c.field_70131_O;
                            this.field_70163_u = this.field_146043_c.func_174813_aQ().field_72338_b + d2 * 0.8;
                            this.field_70161_v = this.field_146043_c.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                    double d0 = this.field_70163_u + this.field_70181_x - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.field_70181_x -= d0 * (double)this.field_70146_Z.nextFloat() * 0.2;
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (iblockstate.func_185904_a() != Material.field_151586_h) {
                this.field_70181_x -= 0.03;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateRotation();
            double d1 = 0.92;
            this.field_70159_w *= d1;
            this.field_70181_x *= d1;
            this.field_70179_y *= d1;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private boolean shouldStopFishing() {
        ItemStack heldMain = this.angler.func_184614_ca();
        ItemStack heldOff = this.angler.func_184592_cb();
        boolean isMain = this.isFishingRod(heldMain);
        boolean isOff = this.isFishingRod(heldOff);
        if (!this.angler.field_70128_L && this.angler.func_70089_S() && (isMain || isOff) && this.func_70068_e((Entity)this.angler) <= 1024.0) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private boolean isFishingRod(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ItemAquacultureFishingRod || item instanceof ItemAdminFishingRod;
    }

    private void updateRotation() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    private void checkCollision() {
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB alignedBB;
            RayTraceResult rayTraceResult;
            if (!this.func_189739_a(entity1) || entity1 == this.angler && this.ticksInAir < 5 || (rayTraceResult = (alignedBB = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72436_e(rayTraceResult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.field_146043_c = raytraceresult.field_72308_g;
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.field_146043_c.func_145782_y() + 1));
    }

    private void catchingFish(BlockPos pos) {
        WorldServer worldserver = (WorldServer)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = pos.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_175678_i(blockpos)) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.field_70181_x -= 0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat();
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.field_70165_t + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                IBlockState state = worldserver.func_180495_p(new BlockPos(d0, d1 - 1.0, d2 = this.field_70161_v + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f)));
                if (state.func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0, new int[0]);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0, new int[0]);
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0, new int[0]);
                }
            } else {
                if (this.angler != null) {
                    int barbed = EnchantmentHelper.func_77506_a((Enchantment)AquacultureEnchants.barbedHook, (ItemStack)this.angler.func_184614_ca());
                    this.ticksCatchable += 4 * barbed;
                }
                if (this.angler != null) {
                    int loot = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.angler.func_184614_ca());
                    this.ticksCatchable += 4 * loot;
                }
                this.field_70181_x = -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                IBlockState state = worldserver.func_180495_p(new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1, (int)(d6 = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f))));
                if (state.func_185904_a() == Material.field_151586_h) {
                    worldserver.func_175739_a(EnumParticleTypes.WATER_SPLASH, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
        }
    }

    protected boolean func_189739_a(Entity entity) {
        return entity.func_70067_L() || entity instanceof EntityItem;
    }

    public int func_146034_e() {
        if (!this.field_70170_p.field_72995_K && this.angler != null) {
            int i = 0;
            if (this.field_146043_c != null) {
                this.func_184527_k();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.field_146043_c instanceof EntityItem ? 3 : 5;
            } else if (this.ticksCatchable > 0 || this.isAdmin) {
                Biome currentBiome = this.field_70170_p.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)this.angler.field_70165_t), 0, MathHelper.func_76128_c((double)this.angler.field_70161_v)));
                int count = 1;
                int doubleHook = EnchantmentHelper.func_77506_a((Enchantment)AquacultureEnchants.doubleHook, (ItemStack)this.angler.func_184614_ca());
                if (doubleHook > 0) {
                    float doubleOdds = 0.1f * (float)doubleHook;
                    if (Math.random() < (double)doubleOdds) {
                        ++count;
                    }
                }
                do {
                    float fishOdds = 0.5f;
                    int magnetic = EnchantmentHelper.func_77506_a((Enchantment)AquacultureEnchants.magnetic, (ItemStack)this.angler.func_184614_ca());
                    int appealing = EnchantmentHelper.func_77506_a((Enchantment)AquacultureEnchants.appealing, (ItemStack)this.angler.func_184614_ca());
                    if (magnetic > 0) {
                        fishOdds = (float)((double)fishOdds - 0.08 * (double)magnetic);
                    } else if (appealing > 0) {
                        fishOdds = (float)((double)fishOdds + 0.08 * (double)appealing);
                    }
                    float roll = (float)Math.random();
                    int heavyLine = 0;
                    if (this.angler != null) {
                        heavyLine = EnchantmentHelper.func_77506_a((Enchantment)AquacultureEnchants.heavyLine, (ItemStack)this.angler.func_184614_ca());
                    }
                    ItemStack fishLoot = roll < fishOdds ? (this.angler.func_184614_ca().func_77973_b() instanceof ItemAdminFishingRod && this.angler.func_70093_af() ? FishLoot.instance().getRandomFish(Biome.func_185362_a((Biome)currentBiome)) : FishLoot.instance().getRandomFish(Biome.func_185362_a((Biome)currentBiome), heavyLine)) : FishLoot.instance().getRandomJunk(Biome.func_185362_a((Biome)currentBiome));
                    if (fishLoot.func_190926_b()) continue;
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, fishLoot);
                    double d0 = this.angler.field_70165_t - this.field_70165_t;
                    double d1 = this.angler.field_70163_u - this.field_70163_u;
                    double d2 = this.angler.field_70161_v - this.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    double d4 = 0.1;
                    entityitem.field_70159_w = d0 * d4;
                    entityitem.field_70181_x = d1 * d4 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                    entityitem.field_70179_y = d2 * d4;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                    this.angler.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.angler.field_70170_p, this.angler.field_70165_t, this.angler.field_70163_u + 0.5, this.angler.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    Item fish = fishLoot.func_77973_b();
                    if (fish != Items.field_151115_aP && fish != Items.field_179566_aV && !(fish instanceof ItemFish)) continue;
                    this.angler.func_71064_a(StatList.field_188071_E, 1);
                } while (--count > 0);
                i = 1;
            }
            if (this.inGround) {
                i = 2;
            }
            this.func_70106_y();
            return i;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.field_146043_c instanceof EntityPlayer && ((EntityPlayer)this.field_146043_c).func_175144_cb()) {
            this.func_184527_k();
        }
        super.func_70103_a(id);
    }

    protected void func_184527_k() {
        if (this.angler != null) {
            double d0 = this.angler.field_70165_t - this.field_70165_t;
            double d1 = this.angler.field_70163_u - this.field_70163_u;
            double d2 = this.angler.field_70161_v - this.field_70161_v;
            double d3 = 0.1;
            this.field_146043_c.field_70159_w += d0 * d3;
            this.field_146043_c.field_70181_x += d1 * d3;
            this.field_146043_c.field_70179_y += d2 * d3;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.angler != null) {
            this.angler.field_71104_cf = null;
        }
    }

    public Entity getThrower() {
        return this.angler;
    }

    public void setThrower(Entity entity) {
    }

    private void calculateVelocity(double par1, double par3, double par5, float par7, float par8) {
        float f2 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)f2;
        par3 /= (double)f2;
        par5 /= (double)f2;
        par1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        this.field_70159_w = par1 *= (double)par7;
        this.field_70181_x = par3 *= (double)par7;
        this.field_70179_y = par5 *= (double)par7;
        float f3 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

