/*
 * Decompiled with CFR 0.152.
 */
package net.craftz.mods.hardcorerevival.handler;

import net.craftz.mods.hardcorerevival.ModConfig;
import net.craftz.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.craftz.mods.hardcorerevival.capability.IHardcoreRevival;
import net.craftz.mods.hardcorerevival.network.MessageRevivalProgress;
import net.craftz.mods.hardcorerevival.network.MessageRevivalSuccess;
import net.craftz.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class RescueHandler {
    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            RescueHandler.abortRescue((EntityPlayer)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        RescueHandler.abortRescue(event.getEntityPlayer());
    }

    public static void startRescue(EntityPlayer player, EntityPlayer target) {
        IHardcoreRevival revival = (IHardcoreRevival)player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        if (revival != null) {
            revival.setRescueTarget(target);
            revival.setRescueTime(0);
            NetworkHandler.instance.sendTo((IMessage)new MessageRevivalProgress(target.func_145782_y(), 0.0f), (EntityPlayerMP)player);
            target.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, SoundEvents.field_187762_di, SoundCategory.PLAYERS, 1.0f, 0.8f);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IHardcoreRevival revival;
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END && (revival = (IHardcoreRevival)event.player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null)) != null && revival.getRescueTarget() != null) {
            if (revival.getRescueTarget().field_70128_L) {
                RescueHandler.abortRescue(event.player);
            } else {
                float dist = event.player.func_70032_d((Entity)revival.getRescueTarget());
                if (dist > ModConfig.maxRescueDist) {
                    RescueHandler.abortRescue(event.player);
                } else {
                    int rescueTime = revival.getRescueTime() + 1;
                    revival.setRescueTime(rescueTime);
                    int step = ModConfig.rescueTime / 4;
                    if (rescueTime >= ModConfig.rescueTime) {
                        RescueHandler.finishRescue(event.player);
                    } else if (rescueTime % step == 0) {
                        NetworkHandler.instance.sendTo((IMessage)new MessageRevivalProgress(revival.getRescueTarget().func_145782_y(), (float)rescueTime / (float)ModConfig.rescueTime), (EntityPlayerMP)event.player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer original = event.getOriginal();
        IHardcoreRevival revival = (IHardcoreRevival)original.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        if (revival != null && revival.getDeathTime() > 0) {
            event.getEntityPlayer().func_70012_b(original.field_70165_t, original.field_70163_u, original.field_70161_v, 0.0f, 0.0f);
        }
    }

    public static void finishRescue(EntityPlayer player) {
        EntityPlayer target;
        IHardcoreRevival revival = (IHardcoreRevival)player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        if (revival != null && (target = revival.getRescueTarget()) != null) {
            double x = target.field_70165_t;
            double y = target.field_70163_u;
            double z = target.field_70161_v;
            float yaw = target.field_70177_z;
            float pitch = target.field_70125_A;
            MinecraftServer server = target.func_184102_h();
            if (server != null) {
                BlockPos prevSpawnPos = target.getBedLocation(target.field_71093_bK);
                boolean prevSpawnForced = target.isSpawnForced(target.field_71093_bK);
                EntityPlayerMP newPlayer = server.func_184103_al().func_72368_a((EntityPlayerMP)target, target.field_71093_bK, false);
                RescueHandler.configureRescuedPlayer(newPlayer, target);
                newPlayer.func_180473_a(prevSpawnPos, prevSpawnForced);
                server.func_152344_a(() -> {
                    int delayTicks = 20;
                    for (int currentTick = 0; currentTick < delayTicks; ++currentTick) {
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    RescueHandler.gentleTeleport(newPlayer, x, y, z, yaw, pitch);
                    NetworkHandler.instance.sendToAllAround((IMessage)new MessageRevivalSuccess(newPlayer.func_145782_y()), new NetworkRegistry.TargetPoint(newPlayer.field_71093_bK, x, y, z, 32.0));
                });
            }
        }
    }

    private static void gentleTeleport(EntityPlayerMP player, double x, double y, double z, float yaw, float pitch) {
        player.func_70080_a(x, y, z, yaw, pitch);
        if (player.field_71135_a != null) {
            player.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
        }
        player.field_70159_w = 0.0;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
    }

    private static void configureRescuedPlayer(EntityPlayerMP newPlayer, EntityPlayer target) {
        newPlayer.func_70606_j((float)ModConfig.rescueRespawnHealth);
        newPlayer.func_71024_bL().func_75114_a(ModConfig.rescueRespawnFoodLevel);
        newPlayer.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 600));
        newPlayer.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 1200));
        newPlayer.field_71071_by.func_70455_b(target.field_71071_by);
        newPlayer.field_71068_ca = target.field_71068_ca;
        newPlayer.field_71067_cb = target.field_71067_cb;
        newPlayer.field_71106_cc = target.field_71106_cc;
        newPlayer.func_70066_B();
        newPlayer.func_85040_s(target.func_71037_bA());
        newPlayer.field_70159_w = 0.0;
        newPlayer.field_70181_x = 0.0;
        newPlayer.field_70179_y = 0.0;
        newPlayer.field_70133_I = true;
    }

    public static void abortRescue(EntityPlayer player) {
        IHardcoreRevival revival = (IHardcoreRevival)player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        if (revival != null) {
            revival.setRescueTime(0);
            revival.setRescueTarget(null);
            NetworkHandler.instance.sendTo((IMessage)new MessageRevivalProgress(-1, -1.0f), (EntityPlayerMP)player);
        }
    }
}

