/*
 * Decompiled with CFR 0.152.
 */
package net.craftz.mods.hardcorerevival.handler;

import net.craftz.mods.hardcorerevival.HardcoreRevival;
import net.craftz.mods.hardcorerevival.ModConfig;
import net.craftz.mods.hardcorerevival.PlayerKnockedOutEvent;
import net.craftz.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.craftz.mods.hardcorerevival.capability.IHardcoreRevival;
import net.craftz.mods.hardcorerevival.network.MessageDie;
import net.craftz.mods.hardcorerevival.network.MessageKnockedOut;
import net.craftz.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DeathHandler {
    public static final String IGNORE_REVIVAL_DEATH = "IgnoreRevivalDeath";

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
        if (event.getSource() == DamageSource.field_76380_i) {
            player.getEntityData().func_74757_a(IGNORE_REVIVAL_DEATH, true);
            NetworkHandler.instance.sendTo((IMessage)new MessageDie(), player);
            return;
        }
        if (event.getSource() == HardcoreRevival.notRescuedInTime || player.getEntityData().func_74767_n(IGNORE_REVIVAL_DEATH)) {
            return;
        }
        event.setCanceled(true);
        double roll = Math.random() * 100.0;
        if (roll >= ModConfig.knockoutChance) {
            player.getEntityData().func_74757_a(IGNORE_REVIVAL_DEATH, true);
            player.func_110142_aN().func_94547_a(event.getSource(), player.func_110143_aJ(), 0.0f);
            player.func_70645_a(event.getSource());
            NetworkHandler.instance.sendTo((IMessage)new MessageDie(), player);
        } else {
            MinecraftServer server;
            player.getEntityData().func_74757_a("InHardcoreRevival", true);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerKnockedOutEvent((EntityPlayer)player, event.getSource()));
            if (ModConfig.glowOnDeath) {
                player.func_184195_f(true);
            }
            player.field_70725_aQ = 1;
            player.field_70737_aN = 10;
            player.field_70738_aO = 10;
            NetworkHandler.instance.sendToAllAround((IMessage)new MessageKnockedOut(player.func_145782_y()), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
            if (player.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && (server = player.field_70170_p.func_73046_m()) != null) {
                Team team = player.func_96124_cp();
                if (team != null && team.func_178771_j() != Team.EnumVisible.ALWAYS) {
                    if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                        server.func_184103_al().func_177453_a((EntityPlayer)player, player.func_110142_aN().func_151521_b());
                    } else if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                        server.func_184103_al().func_177452_b((EntityPlayer)player, player.func_110142_aN().func_151521_b());
                    }
                } else {
                    server.func_184103_al().func_148539_a(player.func_110142_aN().func_151521_b());
                }
            }
        }
    }

    @SubscribeEvent
    public void onDeathUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.START && player.func_110143_aJ() <= 0.0f && !player.getEntityData().func_74767_n(IGNORE_REVIVAL_DEATH) && player.getEntityData().func_74767_n("InHardcoreRevival")) {
            IHardcoreRevival revival;
            if (player.field_70725_aQ >= 19) {
                player.field_70725_aQ = 18;
            }
            if ((revival = (IHardcoreRevival)player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null)) != null) {
                int time = revival.getDeathTime() + 1;
                revival.setDeathTime(time);
                if (time >= ModConfig.maxDeathTicks) {
                    player.getEntityData().func_74757_a(IGNORE_REVIVAL_DEATH, true);
                    NetworkHandler.instance.sendTo((IMessage)new MessageDie(), (EntityPlayerMP)player);
                    player.func_110142_aN().func_94547_a(HardcoreRevival.notRescuedInTime, 0.0f, 0.0f);
                    player.func_70645_a(HardcoreRevival.notRescuedInTime);
                    revival.setDeathTime(0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        IHardcoreRevival revival;
        event.player.getEntityData().func_82580_o(IGNORE_REVIVAL_DEATH);
        event.player.getEntityData().func_82580_o("InHardcoreRevival");
        if (ModConfig.glowOnDeath) {
            event.player.func_184195_f(false);
        }
        if ((revival = (IHardcoreRevival)event.player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null)) != null) {
            revival.setDeathTime(0);
        }
    }
}

