/*
 * Decompiled with CFR 0.152.
 */
package net.craftz.mods.hardcorerevival.client;

import net.craftz.mods.hardcorerevival.CommonProxy;
import net.craftz.mods.hardcorerevival.HardcoreRevival;
import net.craftz.mods.hardcorerevival.ModConfig;
import net.craftz.mods.hardcorerevival.client.GuiHelper;
import net.craftz.mods.hardcorerevival.network.MessageDie;
import net.craftz.mods.hardcorerevival.network.MessageRevival;
import net.craftz.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private boolean isKnockedOut;
    private boolean acceptedDeath;
    private int deathTime;
    private float enableButtonTimer;
    private GuiButton buttonDie;
    private float prevChatHeight = -1.0f;
    private boolean isRescuing;
    private int targetEntity = -1;
    private float targetProgress;
    private float prevRotationPitch;
    private float prevRotationYaw;
    private static final String RESCUE_PROMPT = "\u00a7c[\u041f\u041a\u041c] \u0421\u043f\u0430\u0441\u0442\u0438";

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            if (event.getGui() instanceof GuiGameOver) {
                if (mc.field_71439_g.getEntityData().func_74767_n("InHardcoreRevival") && !this.acceptedDeath) {
                    event.setGui(null);
                }
            } else if (mc.field_71439_g.getEntityData().func_74767_n("InHardcoreRevival") && !(event.getGui() instanceof GuiChat)) {
                event.setGui(null);
            }
        }
    }

    @SubscribeEvent
    public void onFov(FOVUpdateEvent event) {
        if (this.isKnockedOut) {
            event.setNewfov(0.5f);
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Chat event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && this.isKnockedOut && mc.field_71462_r != null) {
            this.prevChatHeight = mc.field_71474_y.field_96694_H;
            mc.field_71474_y.field_96694_H = 0.1f;
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.PORTAL) {
            Entity entity;
            Minecraft mc = Minecraft.func_71410_x();
            if (this.isKnockedOut) {
                this.renderKnockoutDarkness(mc, this.deathTime);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
                GuiHelper.drawGradientRectW(0, 0, mc.field_71443_c, mc.field_71440_d, 0x60500000, -1862336512);
                GlStateManager.func_179121_F();
                if (mc.field_71462_r == null) {
                    mc.field_71466_p.func_175063_a(I18n.func_135052_a((String)"gui.hardcorerevival.open_death_screen", (Object[])new Object[]{mc.field_71474_y.field_74310_D.getDisplayName()}), 5.0f, 5.0f, -1);
                    mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.hardcorerevival.rescue_time_left", (Object[])new Object[]{Math.max(0, (ModConfig.maxDeathTicks - this.deathTime) / 20)}), 5, 7 + mc.field_71466_p.field_78288_b, 0xFFFFFF);
                    mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                }
            } else if (this.targetEntity != -1 && (entity = mc.field_71441_e.func_73045_a(this.targetEntity)) instanceof EntityPlayer) {
                String s = I18n.func_135052_a((String)"gui.hardcorerevival.rescuing", (Object[])new Object[]{((EntityPlayer)entity).getDisplayNameString()});
                if (this.targetProgress >= 0.75f) {
                    s = s + " ...";
                } else if (this.targetProgress >= 0.5f) {
                    s = s + " ..";
                } else if (this.targetProgress >= 0.25f) {
                    s = s + " .";
                }
                mc.field_71466_p.func_78276_b(s, event.getResolution().func_78326_a() / 2 - mc.field_71466_p.func_78256_a(s) / 2, event.getResolution().func_78328_b() / 2 + 30, -1);
                mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT && this.prevChatHeight != -1.0f) {
            Minecraft.func_71410_x().field_71474_y.field_96694_H = this.prevChatHeight;
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.func_110143_aJ() <= 0.0f) {
            while (mc.field_71474_y.field_74316_C.func_151468_f()) {
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                if (mc.field_71439_g.func_110143_aJ() <= 0.0f) {
                    if (!this.isKnockedOut && !this.acceptedDeath && mc.field_71439_g.getEntityData().func_74767_n("InHardcoreRevival")) {
                        this.deathTime = 0;
                        this.isKnockedOut = true;
                        mc.func_147108_a((GuiScreen)new GuiChat());
                    }
                    if (mc.field_71439_g.field_70725_aQ == 19) {
                        mc.field_71439_g.field_70725_aQ = 18;
                    }
                    if (this.isKnockedOut) {
                        ++this.deathTime;
                    }
                } else {
                    this.isKnockedOut = false;
                    this.acceptedDeath = false;
                    this.deathTime = 0;
                    if (Mouse.isButtonDown((int)1)) {
                        if (!this.isRescuing) {
                            NetworkHandler.instance.sendToServer((IMessage)new MessageRevival(true));
                            this.isRescuing = true;
                        }
                    } else if (this.isRescuing) {
                        NetworkHandler.instance.sendToServer((IMessage)new MessageRevival(false));
                        this.isRescuing = false;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Minecraft mc = event.getGui().field_146297_k;
        if (mc.field_71439_g != null && this.isKnockedOut && event.getGui() instanceof GuiChat) {
            GuiScreen gui = event.getGui();
            this.enableButtonTimer = 0.0f;
            this.buttonDie = new GuiButton(-2, gui.field_146294_l / 2 - 100, gui.field_146295_m / 2 - 30, I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]));
            this.buttonDie.field_146124_l = false;
            event.getButtonList().add(this.buttonDie);
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() == this.buttonDie) {
            event.getButton().func_146113_a(Minecraft.func_71410_x().func_147118_V());
            NetworkHandler.instance.sendToServer((IMessage)new MessageDie());
            this.acceptedDeath = true;
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiScreen gui = event.getGui();
        Minecraft mc = gui.field_146297_k;
        if (mc.field_71439_g != null && this.isKnockedOut && gui instanceof GuiChat) {
            this.enableButtonTimer += event.getRenderPartialTicks();
            if (this.buttonDie != null) {
                if (this.enableButtonTimer >= 40.0f) {
                    this.buttonDie.field_146124_l = true;
                    this.buttonDie.field_146126_j = I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]);
                } else if (this.enableButtonTimer >= 30.0f) {
                    this.buttonDie.field_146126_j = "... " + I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]) + " ...";
                } else if (this.enableButtonTimer >= 20.0f) {
                    this.buttonDie.field_146126_j = ".. " + I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]) + " ..";
                } else if (this.enableButtonTimer >= 10.0f) {
                    this.buttonDie.field_146126_j = ". " + I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]) + " .";
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            gui.func_73732_a(mc.field_71466_p, I18n.func_135052_a((String)"gui.hardcorerevival.knocked_out", (Object[])new Object[0]), gui.field_146294_l / 2 / 2, 30, 0xFFFFFF);
            GlStateManager.func_179121_F();
            gui.func_73732_a(mc.field_71466_p, I18n.func_135052_a((String)"gui.hardcorerevival.rescue_time_left", (Object[])new Object[]{Math.max(0, (ModConfig.maxDeathTicks - this.deathTime) / 20)}), gui.field_146294_l / 2, gui.field_146295_m / 2 + 10, 0xFFFFFF);
        } else if (this.buttonDie != null) {
            this.buttonDie.field_146125_m = false;
        }
    }

    @Override
    public void receiveDeathTime(int deathTime) {
        this.deathTime = deathTime;
    }

    @Override
    public void receiveRevivalProgress(int entityId, float progress) {
        this.targetEntity = entityId;
        this.targetProgress = progress;
    }

    @Override
    public void receiveDeath() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            mc.field_71439_g.getEntityData().func_74757_a("InHardcoreRevival", true);
            this.isKnockedOut = true;
            this.acceptedDeath = true;
            Minecraft.func_71410_x().field_71439_g.func_184185_a(HardcoreRevival.KNOCKOUT_SOUND, 0.8f, 1.0f + (Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat() * 0.1f - 0.05f));
            if (ModConfig.glowOnDeath) {
                mc.field_71439_g.func_184195_f(false);
                mc.field_71439_g.func_70052_a(6, false);
            }
        }
    }

    @SubscribeEvent
    public void onMouseClickedinRevival(MouseEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && this.isKnockedOut) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClientTick2(TickEvent.ClientTickEvent event) {
        if (event.side != Side.CLIENT || event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (this.isKnockedOut) {
            player.field_70125_A = -90.0f;
            player.field_70177_z = 0.0f;
            player.field_70127_C = this.prevRotationPitch;
            player.field_70126_B = this.prevRotationYaw;
            player.func_70095_a(false);
            player.field_70159_w = 0.0;
            player.field_70181_x = 0.0;
            player.field_70179_y = 0.0;
            player.field_70747_aH = 0.0f;
            player.field_191988_bg = 0.0f;
            player.field_70702_br = 0.0f;
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-1.5);
            MovementInput movementInput = player.field_71158_b;
            if (player.field_71158_b != null) {
                player.field_71158_b.field_192832_b = 0.0f;
                player.field_71158_b.field_78902_a = 0.0f;
                player.field_71158_b.field_78899_d = false;
                player.field_71158_b.field_78901_c = false;
            }
            GameSettings settings = mc.field_71474_y;
            if (Keyboard.isKeyDown((int)settings.field_74311_E.func_151463_i())) {
                KeyBinding cfr_ignored_0 = settings.field_74311_E;
                KeyBinding.func_74510_a((int)settings.field_74311_E.func_151463_i(), (boolean)false);
            }
        }
    }

    @SubscribeEvent
    public void onChatSend(ClientChatEvent event) {
        if (this.isKnockedOut && event.getMessage().startsWith("/")) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString("\u00a7c\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0432 \u043e\u0431\u043c\u043e\u0440\u043e\u043a\u0435."));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        Entity entity;
        RayTraceResult result;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && !this.isKnockedOut && (result = mc.field_71476_x) != null && result.field_72313_a == RayTraceResult.Type.ENTITY && (entity = result.field_72308_g) instanceof EntityPlayer) {
            EntityPlayer target = (EntityPlayer)entity;
            if (target.field_70725_aQ > 0 && target.field_70725_aQ < 20) {
                ScaledResolution resolution = event.getResolution();
                int x = resolution.func_78326_a() / 2;
                int y = resolution.func_78328_b() / 2;
                mc.field_71466_p.func_175063_a(RESCUE_PROMPT, (float)(x - mc.field_71466_p.func_78256_a(RESCUE_PROMPT) / 2), (float)(y + 20), 0xFFFFFF);
            }
        }
    }

    private void renderKnockoutDarkness(Minecraft mc, int deathTime) {
        float maxDarkness = 0.9f;
        int baseColor = 0;
        int dangerColor = 0xFF0000;
        float pulseSpeed = 0.1f;
        float darkness = Math.min(maxDarkness, (float)deathTime / 200.0f);
        ScaledResolution res = new ScaledResolution(mc);
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int alpha = (int)(144.0f * darkness);
        Gui.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)(alpha << 24 | baseColor));
        for (int i = 0; i < 10; ++i) {
            int vignetteAlpha = (int)(48.0f * darkness * (float)(10 - i) / 10.0f);
            Gui.func_73734_a((int)i, (int)i, (int)(width - i), (int)(height - i), (int)(vignetteAlpha << 24 | baseColor));
        }
        if ((float)deathTime > (float)ModConfig.maxDeathTicks * 0.7f) {
            float pulse = (float)Math.sin((float)deathTime * pulseSpeed) * 0.1f + 0.9f;
            int pulseAlpha = (int)(64.0f * pulse * darkness);
            Gui.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)(pulseAlpha << 24 | dangerColor));
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

