/*
 * Decompiled with CFR 0.152.
 */
package net.craftz.mods.hardcorerevival;

import net.craftz.mods.hardcorerevival.CommonProxy;
import net.craftz.mods.hardcorerevival.ModConfig;
import net.craftz.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.craftz.mods.hardcorerevival.handler.DeathHandler;
import net.craftz.mods.hardcorerevival.handler.PlayerHandler;
import net.craftz.mods.hardcorerevival.handler.RescueHandler;
import net.craftz.mods.hardcorerevival.handler.RestrictionHandler;
import net.craftz.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="hardcorerevival", name="Hardcore Revival", acceptedMinecraftVersions="1.12")
@Mod.EventBusSubscriber
public class HardcoreRevival {
    public static final SoundEvent KNOCKOUT_SOUND = SoundEvents.field_187855_gD;
    public static final SoundEvent RESCUED_SOUND = SoundEvents.field_189109_ed;
    public static final SoundEvent RESCUING_SOUND = SoundEvents.field_193807_ew;
    public static final SoundEvent KNOCKOUT2_SOUND = SoundEvents.field_190023_cJ;
    public static final String MOD_ID = "hardcorerevival";
    @Mod.Instance(value="hardcorerevival")
    public static HardcoreRevival instance;
    @SidedProxy(clientSide="net.craftz.mods.hardcorerevival.client.ClientProxy", serverSide="net.craftz.mods.hardcorerevival.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static final DamageSource notRescuedInTime;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RestrictionHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DeathHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RescueHandler());
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        CapabilityHardcoreRevival.register();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT && ModConfig.teamUpIntegration) {
            event.buildSoftDependProxy("teamup", "net.craftz.mods.hardcorerevival.compat.TeamUpAddon", new Object[0]);
        }
        if (event.getSide() == Side.CLIENT && ModConfig.pingIntegration) {
            event.buildSoftDependProxy("ping", "net.craftz.mods.hardcorerevival.compat.PingAddon", new Object[0]);
        }
    }

    static {
        notRescuedInTime = new DamageSource("not_rescued_in_time");
    }
}

